/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH ajobs AS (
    SELECT
        id,
        volume_id,
        CONCAT('/', path) AS path,
        target_id,
        archive_target_name,
        status,
        creation_time,
        end_time,
        EXTRACT(EPOCH FROM (end_time - creation_time)) AS time,
        JSONB_ARRAY_ELEMENTS_TEXT(low_level_jobs::JSONB->'UPLOADING_FILES')::BIGINT AS llj
    FROM sf_archive.archive_job
    WHERE creation_time >= NOW() - INTERVAL '{{number_of_days_to_look_back}} day'
),
jobs AS (
    SELECT
        ajobs.id AS ajob_id,
        ajobs.status,
        vol.name AS volume,
        mount.path AS volume_path,
        ajobs.path AS archive_path,
        ajobs.archive_target_name AS target_name,
        at.type AS target_type,
        ajobs.status AS ajob_status,
        ajobs.creation_time,
        ROUND(((sji.fs_stats->>'fs_bytes_done')::BIGINT / (1000 * 1000.0)),2) AS bytes,
        (sji.fs_stats->>'fs_entries_done')::BIGINT AS files_count,
        CASE WHEN ajobs.time != 0
            THEN (sji.fs_stats->>'fs_bytes_done')::BIGINT / (1000 * 1000.0) / ajobs.time
        ELSE 0.00 END AS bandwidth
    FROM ajobs
    INNER JOIN sf_dispatcher.incarnation sji ON ajobs.llj = sji.job_id
    LEFT JOIN sf_archive.archive_target at ON ajobs.target_id = at.id
    LEFT JOIN sf_volumes.volume vol ON vol.id = ajobs.volume_id
    LEFT JOIN sf_volumes.mount mount ON mount.volume_id = vol.id AND mount.agent = vol.default_agent_address
)

SELECT DISTINCT
    ajob_id AS "job id",
    ajob_status AS "status",
    CONCAT(volume, ':', archive_path) AS source,
    CONCAT(volume_path, archive_path) AS source_sys_path,
    target_name AS target,
    target_type,
    bytes AS "MB sent",
    files_count,
    bandwidth AS "MB/s"
FROM jobs
WHERE bytes IS NOT NULL
ORDER BY bytes DESC, files_count DESC, ajob_id ASC
