/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH result_age AS (
    SELECT f.uid,
           f.gid,
           f.volume_id,
           sf_reports.interval_to_age_bucket(current_timestamp - f.atime) as atime_age,
           sf_reports.interval_to_age_bucket(current_timestamp - f.mtime) as mtime_age,
           CASE
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) <= 0 THEN '0B'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 1024::BIGINT THEN '1B ... <1KiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 10::BIGINT * 1024 THEN '1KiB ... <10KiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 100::BIGINT * 1024 THEN '10KiB ... <100KiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 1024::BIGINT * 1024 THEN '100KiB ... <1MiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 10::BIGINT * 1024 * 1024 THEN '1MiB ... <10MiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 100::BIGINT * 1024 * 1024 THEN '10MiB ... <100MiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 1024::BIGINT * 1024 * 1024 THEN '100MiB ... <1GiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 10::BIGINT * 1024 * 1024 * 1024 THEN '1GiB ... <10GiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 100::BIGINT * 1024 * 1024 * 1024 THEN '10GiB ... <100GiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 1024::BIGINT * 1024 * 1024 * 1024 THEN '100GiB ... <1TiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 10::BIGINT * 1024 * 1024 * 1024 * 1024 THEN '1TiB ... <10TiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 100::BIGINT * 1024 * 1024 * 1024 * 1024 THEN '10TiB ... <100TiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 1024::BIGINT * 1024 * 1024 * 1024 * 1024 THEN '100TiB ... <1PiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 10::BIGINT * 1024 * 1024 * 1024 * 1024 * 1024 THEN '1PiB ... <10PiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 100::BIGINT * 1024 * 1024 * 1024 * 1024 * 1024 THEN '10PiB ... <100PiB'
               WHEN (f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) < 1024::BIGINT * 1024 * 1024 * 1024 * 1024 * 1024 THEN '100PiB ... <1EiB'
               ELSE '>=1EiB'
           END AS physical_size_bucket,
           SUM(size) AS logical_size,
           SUM(f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) AS physical_size,
           COUNT(*) AS count
    FROM sf.file_current as f
    GROUP BY f.uid, f.gid, f.volume_id, atime_age, mtime_age, physical_size_bucket
)
SELECT v.name AS volume_name,
       COALESCE(um.name, CAST(r.uid AS TEXT)) AS user_name,
       COALESCE(gm.name, CAST(r.gid AS TEXT)) AS group_name,
       r.uid,
       r.gid,
       atime_age,
       mtime_age,
       ab_atime.lower_bound_month as atime_months_lower_bound,
       ab_mtime.lower_bound_month as mtime_months_lower_bound,
       logical_size AS size, -- this is backward compatibility - we cannot rename already existing columns
       physical_size,
       physical_size_bucket,
       SUM(physical_size) OVER (PARTITION BY r.uid) AS user_total_size,
       CASE
            WHEN COALESCE(v.total_capacity, 0) > 0 THEN ROUND(physical_size * 100.0 / v.total_capacity, 1)
            ELSE NULL
       END AS percent_of_whole_volume,
       count::NUMERIC as count,
       physical_size / (1000 * 1000 * 1000.0) * CAST(COALESCE(vupc.value, '0') AS FLOAT) AS cost
FROM result_age AS r
    JOIN sf_volumes.volume AS v ON r.volume_id=v.id
    LEFT JOIN sf.gid_mapping AS gm ON r.volume_id=gm.volume_id AND r.gid=gm.gid
    LEFT JOIN sf.uid_mapping AS um ON r.volume_id=um.volume_id AND r.uid=um.uid
    LEFT JOIN sf_volumes.user_param AS vupc ON vupc.volume_id = v.id AND vupc.name = 'cost_per_gb'
    LEFT JOIN sf_reports.age_buckets AS ab_atime ON r.atime_age = ab_atime.label
    LEFT JOIN sf_reports.age_buckets AS ab_mtime ON r.mtime_age = ab_mtime.label
