/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */


CREATE OR REPLACE FUNCTION __get_tablespace(full_tablename VARCHAR)
RETURNS VARCHAR AS  -- returns NULL if the table is in default tablespace or it does not exist
$$
DECLARE
    result VARCHAR;
BEGIN
    SELECT tablespace
      INTO result
      FROM pg_tables
     WHERE (schemaname || '.' || tablename) = full_tablename;

    RETURN result;
END;
$$ LANGUAGE plpgsql STRICT IMMUTABLE PARALLEL SAFE;


CREATE OR REPLACE FUNCTION __move_to_same_custom_tablespace(table_to_move VARCHAR, reference_table VARCHAR)
RETURNS VOID AS
$$
DECLARE
    tblspc VARCHAR;
BEGIN
    SELECT __get_tablespace(reference_table) INTO tblspc;
    IF tblspc IS NOT NULL THEN
        EXECUTE 'ALTER TABLE ' || table_to_move || ' SET TABLESPACE ' || quote_ident(tblspc);
    END IF;
END;
$$ LANGUAGE plpgsql STRICT VOLATILE PARALLEL UNSAFE;

DROP INDEX IF EXISTS sf.calculated_aggrs_id;

ALTER TABLE sf.calculated_aggrs RENAME TO calculated_aggrs_old;

CREATE TABLE sf.calculated_aggrs(
    id bigint,
    rec_aggrs jsonb,
    local_aggrs jsonb,
    volume_id bigint NOT NULL
) PARTITION BY HASH (volume_id partition_custom_bigint_hash_op);

CREATE UNIQUE INDEX calculated_aggrs_id ON sf.calculated_aggrs USING btree (volume_id, id);

-- intentionally not migrating autovacuum_analyze_threshold=1000000000 to enable autovacuum on this table,
-- as we do not truncate it anymore
