/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

-- the function is needed because concat(mount.path, '/', dir.path, '/', file.name) is not enough
-- there are edge cases which need to be handled

CREATE OR REPLACE FUNCTION get_full_sys_path(mount_path TEXT,
                                             dir_path TEXT,
                                             file_name TEXT)
RETURNS TEXT
LANGUAGE plpgsql
AS $$
DECLARE
    separator CHAR := '/';
    -- CONCAT('^', separator) would not be enough to check if to add a separator after or not
    unix_path_regex_check TEXT := CONCAT('^', separator, '[^', separator, ']');
    non_unix_path_regex_check TEXT := CONCAT('^[^', separator, ']');
    full_path TEXT;
BEGIN
    full_path := mount_path;
    -- add separator only if there is a need (dir_path != '')
    -- checking with regex in case if mount_path is '/' (something different than the (UNIX) separator at the very end to not repeat char)
    -- mount_path has to start with a separator (UNIX), this is to not add '/' after Windows mount_path
    IF dir_path != '' AND mount_path ~ unix_path_regex_check THEN
        full_path := CONCAT(full_path, separator);
    END IF;
    full_path := CONCAT(full_path, dir_path);
    -- add separator but only if file_name was passed
    -- for Linux path has to be different than '/' and for Windows dir_path != ''
    IF file_name != '' AND (full_path ~ unix_path_regex_check OR (full_path ~ non_unix_path_regex_check AND dir_path != '')) THEN
        full_path := CONCAT(full_path, separator);
    END IF;
    RETURN CONCAT(full_path, file_name);
END;
$$;
