/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

CREATE TEMP TABLE process_event_temp_loadevents_dir_delete (
    LIKE sf.dir_current
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE process_event_temp_dir_ids_not_to_delete (
    dir_id BIGINT
) ON COMMIT DELETE ROWS;
CREATE INDEX dir_id_idx ON process_event_temp_dir_ids_not_to_delete(dir_id);

CREATE TEMP TABLE process_event_temp_processing_stats (
    stat_name TEXT,
    type TEXT,
    size NUMERIC,
    count BIGINT
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE fill_missing_parents_parent_path (
    path TEXT,
    depth sf.depth_t,
    min_sync_time sf.time_t
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE fill_missing_parents_dir_path (
    path TEXT,
    depth sf.depth_t
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE fill_missing_parents_parent_path_not_in_batch (
    path TEXT,
    min_sync_time sf.time_t
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE fill_missing_parents_parent_missing_parent (
    path TEXT,
    min_sync_time sf.time_t
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE load_events_events_with_entries (
    dir_row sf.dir_current,
    file_row sf.file_current,
    parent_id BIGINT,
    parent_ancestor_ids BIGINT[],
    event_row sf_internal.event_base
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE calculate_aggrs_dir_process (
    id BIGINT,
    volume_id BIGINT,
    parent_id BIGINT,
    depth sf.depth_t,
    size sf.off_t,
    blocks sf.blkcnt_t,
    atime sf.time_t,
    ctime sf.time_t,
    mtime sf.time_t,
    sync_time sf.time_t,
    local_aggrs JSONB
) ON COMMIT DELETE ROWS;
CREATE INDEX calculate_aggrs_dir_process_indx ON calculate_aggrs_dir_process(id);

CREATE TEMP TABLE calculate_aggrs_files_for_processed_dirs (
    parent_id BIGINT,
    volume_id BIGINT,
    size sf.off_t,
    blocks sf.blkcnt_t,
    nlinks BIGINT,
    uid sf.uid_t,
    gid sf.gid_t,
    atime sf.time_t,
    mtime sf.time_t,
    ctime sf.time_t,
    ext TEXT,
    sync_time sf.time_t
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE calculate_aggrs_subdirs_in_processed_dirs (
    id BIGINT,
    volume_id BIGINT,
    parent_id BIGINT,
    rec_aggrs JSONB,
    blocks sf.blkcnt_t,
    size NUMERIC
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE calculate_aggrs_dir_agg_values (
    id BIGINT,
    volume_id BIGINT,
    rec_size NUMERIC,
    rec_blocks NUMERIC,
    rec_size_div_nlinks NUMERIC,
    rec_blocks_div_nlinks NUMERIC,
    rec_dir_count NUMERIC,
    rec_file_count NUMERIC,
    rec_min_dir_file_atime DOUBLE PRECISION,
    rec_max_file_atime DOUBLE PRECISION,
    rec_avg_dir_file_atime DOUBLE PRECISION,
    rec_min_dir_file_ctime DOUBLE PRECISION,
    rec_max_dir_file_ctime DOUBLE PRECISION,
    rec_min_dir_file_mtime DOUBLE PRECISION,
    rec_max_dir_file_mtime DOUBLE PRECISION,
    rec_avg_dir_file_mtime DOUBLE PRECISION,
    rec_max_sync_time DOUBLE PRECISION,
    local_file_count NUMERIC,
    local_dir_count NUMERIC,
    local_size NUMERIC,
    local_blocks NUMERIC,
    local_blocks_div_nlinks NUMERIC,
    local_size_div_nlinks NUMERIC,
    local_min_file_atime DOUBLE PRECISION,
    local_min_file_ctime DOUBLE PRECISION,
    local_min_file_mtime DOUBLE PRECISION,
    local_max_file_atime DOUBLE PRECISION,
    local_max_file_ctime DOUBLE PRECISION,
    local_max_file_mtime DOUBLE PRECISION,
    local_avg_file_atime DOUBLE PRECISION,
    local_avg_file_mtime DOUBLE PRECISION,
    local_file_by_ext JSONB,
    local_file_by_uid JSONB,
    local_file_by_gid JSONB
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE calculate_aggrs_dir_agg_json (
    id BIGINT,
    volume_id BIGINT,
    rec_aggrs JSONB,
    local_aggrs JSONB
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE inserted_ids (
    seq_num BIGINT,
    id BIGINT
) ON COMMIT DELETE ROWS;

CREATE TEMP TABLE inserted_custom_fs_attrs_ids (
    seq_num BIGINT,
    custom_fs_attrs_id BIGINT
) ON COMMIT DELETE ROWS;
