# ***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
# ***********************************************************************************************************
"""
    convert job query from list of lists to query string
"""
import logging
import warnings

from sqlalchemy import exc as sa_exc, text
from alembic import op
from sqlalchemy import Table, MetaData, select, update

# revision identifiers, used by Alembic.
from sqlalchemy.orm import Session

from sfutils.query.backward_compatibility import old_job_plain_list_filter_tokens_to_query_str

revision = "0010"
down_revision = "0009"
branch_labels = None
depends_on = None

logger = logging.getLogger(__name__)


def upgrade():
    with warnings.catch_warnings():
        # otherwise it warns that:
        # "SAWarning: Skipped unsupported reflection of expression-based index"
        # on job_dst_path and job_root_path
        warnings.simplefilter("ignore", category=sa_exc.SAWarning)

        engine = op.get_bind()
        session = Session(bind=engine)
        metadata = MetaData(schema="sf_dispatcher")
        job_table = Table("job", metadata, autoload_with=engine, extend_existing=True)
        conn = session.connection()

    for job_id, options in conn.execute(text(str(select(job_table.c.id, job_table.c.options)))):
        if options is None:
            continue

        # change query to query_str, but keep old query just in case
        query = options.get("query", [])
        query_str = old_job_plain_list_filter_tokens_to_query_str(query)
        logger.info(f"Changing job {job_id} query from {query!r} to {query_str!r}")
        options["query_str"] = query_str
        conn.execute(update(job_table).where(job_table.c.id == job_id).values(options=options))
