# ***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
# ***********************************************************************************************************

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "0002"
down_revision = "0001"
branch_labels = None
depends_on = None


def upgrade():
    op.execute(
        """
create sequence sf_archive.archive_target_id_seq start with 1;
"""
    )
    op.create_table(
        "archive_target",
        sa.Column(
            "id",
            sa.BigInteger(),
            server_default=sa.text("nextval('sf_archive.archive_target_id_seq'::regclass)"),
            nullable=False,
        ),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column(
            "type",
            sa.Enum(
                "s3",
                "swift",
                "volume",
                native_enum=False,
                create_constraint=True,
                constraint_name="archive_target_type_check",
            ),
            nullable=False,
        ),
        sa.Column("params", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        schema="sf_archive",
    )

    status_enum = sa.Enum(
        "PAUSING",
        "STARTING",
        "DONE",
        "FAILED",
        "RESUMING",
        "PAUSED",
        "TIMEOUT",
        "IN_PROGRESS",
        "STOPPING",
        "STOPPED",
        name="archive_job_statuses",
    )

    op.execute(
        """
create sequence sf_archive.archive_job_id_seq start with 1;
"""
    )
    op.create_table(
        "archive_job",
        sa.Column(
            "id",
            sa.BigInteger(),
            server_default=sa.text("nextval('sf_archive.archive_job_id_seq'::regclass)"),
            nullable=False,
        ),
        sa.Column("status", status_enum, nullable=False),
        sa.Column("volume_id", sa.BigInteger(), nullable=False),
        sa.Column("path", sa.Text(), nullable=False),
        sa.Column("target_id", sa.BigInteger(), nullable=False),
        sa.Column("query", sa.Text(), nullable=False),
        sa.Column("command", sa.Text(), nullable=False),
        sa.Column("remove_source", sa.Boolean(), nullable=False),
        sa.Column("generate_manifests", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(["target_id"], ["sf_archive.archive_target.id"], ondelete="RESTRICT"),
        sa.PrimaryKeyConstraint("id"),
        schema="sf_archive",
    )
    op.create_table(
        "archive_low_level_job",
        sa.Column("job_id", sa.BigInteger(), nullable=False),
        sa.Column("parent_id", sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(["parent_id"], ["sf_archive.archive_job.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("job_id", "parent_id"),
        schema="sf_archive",
    )

    op.execute(
        """
create sequence sf_archive.restore_job_id_seq start with 1;
"""
    )
    op.create_table(
        "restore_job",
        sa.Column(
            "id",
            sa.BigInteger(),
            server_default=sa.text("nextval('sf_archive.restore_job_id_seq'::regclass)"),
            nullable=False,
        ),
        sa.Column("status", status_enum, nullable=False),
        sa.Column("src_volume_id", sa.BigInteger(), nullable=False),
        sa.Column("src_path", sa.Text(), nullable=False),
        sa.Column("dst_volume_id", sa.BigInteger(), nullable=True),
        sa.Column("dst_path", sa.Text(), nullable=True),
        sa.Column("query", sa.Text(), nullable=False),
        sa.Column("no_permissions", sa.Boolean(), nullable=False),
        sa.Column("restore_permissions_even_if_not_root", sa.Boolean(), nullable=False),
        sa.Column("keep_archive_dirs", sa.Boolean(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        schema="sf_archive",
    )
    op.create_table(
        "restore_low_level_job",
        sa.Column("job_id", sa.BigInteger(), nullable=False),
        sa.Column("parent_id", sa.BigInteger(), nullable=False),
        sa.ForeignKeyConstraint(["parent_id"], ["sf_archive.restore_job.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("job_id", "parent_id"),
        schema="sf_archive",
    )
