/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

CREATE OR REPLACE FUNCTION sf_auth.check_no_rows_in_{{ association_table }}_for_modified_row() RETURNS trigger AS
$$BEGIN
    IF (SELECT count(*)
        FROM sf_auth.{{ association_table }}
            WHERE {{ subject_table }}_{{ subject_id_column }} = NEW.{{ subject_id_column }}
        ) > 0
    THEN
        RAISE 'cannot set {{ subject_table }}.{{ wildcard_switch_column }} to true because of rows in sf_auth.{{ association_table }}, '
            '{{ subject_table }}.{{ subject_id_column }}: %', NEW.{{ subject_id_column }}
        USING ERRCODE = 'check_violation';
   END IF;

   RETURN NEW;
END;$$ LANGUAGE plpgsql STABLE PARALLEL SAFE;

CREATE CONSTRAINT TRIGGER {{ subject_table }}_cannot_have_specific_{{ object }}s_if_{{ wildcard_switch_column }}
   AFTER UPDATE ON sf_auth.{{ subject_table }}
   DEFERRABLE INITIALLY DEFERRED
   FOR EACH ROW
   WHEN (NEW.{{ wildcard_switch_column }} AND NOT OLD.{{ wildcard_switch_column }})
   EXECUTE PROCEDURE sf_auth.check_no_rows_in_{{ association_table }}_for_modified_row();


CREATE OR REPLACE FUNCTION sf_auth.check_{{ wildcard_switch_column }}_when_adding_{{ object }}_to_{{ subject_table }}() RETURNS trigger AS
$$BEGIN
   IF (SELECT {{ wildcard_switch_column }}
         FROM sf_auth.{{ subject_table }}
        WHERE {{ subject_id_column }} = NEW.{{ subject_table }}_{{ subject_id_column }}
      )
   THEN
      RAISE 'cannot add {{ object }} to {{ subject_table }} because {{ wildcard_switch_column }} is true, {{ subject_table }}.{{ subject_id_column }}: %',
            NEW.{{ subject_table }}_{{ subject_id_column }}
        USING ERRCODE = 'check_violation';
   END IF;

   RETURN NEW;
END;$$ LANGUAGE plpgsql STABLE PARALLEL SAFE;

CREATE CONSTRAINT TRIGGER insert_cannot_add_{{ object }}_to_{{ subject_table }}_if_{{ wildcard_switch_column }}
   AFTER INSERT ON sf_auth.{{ association_table }}
   DEFERRABLE INITIALLY DEFERRED
   FOR EACH ROW
   EXECUTE PROCEDURE sf_auth.check_{{ wildcard_switch_column }}_when_adding_{{ object }}_to_{{ subject_table }}();

CREATE CONSTRAINT TRIGGER update_cannot_add_{{ object }}_to_{{ subject_table }}_if_{{ wildcard_switch_column }}
   AFTER UPDATE ON sf_auth.{{ association_table }}
   DEFERRABLE INITIALLY DEFERRED
   FOR EACH ROW
   WHEN (NEW.{{ subject_table }}_{{ subject_id_column }} IS DISTINCT FROM OLD.{{ subject_table }}_{{ subject_id_column }})
   EXECUTE PROCEDURE sf_auth.check_{{ wildcard_switch_column }}_when_adding_{{ object }}_to_{{ subject_table }}();
