/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

CREATE TABLE sf.recoverable_aggrs (
    volume_id BIGINT NOT NULL,
    path TEXT NOT NULL,
    files_size BIGINT NOT NULL,
    files_blocks_div_nlinks NUMERIC NOT NULL,
    files_count BIGINT NOT NULL
);

CREATE UNIQUE INDEX recoverable_volumeid_path_unique_idx ON sf.recoverable_aggrs (volume_id, path text_pattern_ops);

CREATE TABLE sf.recoverable_aggrs_calculation_time (
    volume_id BIGINT PRIMARY KEY,
    calculation_timestamp TIMESTAMP WITH TIME ZONE NOT NULL,
    requested_timestamp TIMESTAMP WITH TIME ZONE NOT NULL
);
