/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */



CREATE TEMP TABLE required_abilities(
	type TEXT,
	method TEXT,
	value TEXT
);

INSERT INTO required_abilities VALUES
				( 'license', 'read', NULL),
				( 'mapping', 'read', NULL),
				( 'tag', 'read', NULL),
				( 'fs_entry', 'read', NULL),
				( 'namespace', 'read', NULL),
				( 'zone', 'read', NULL),
				( 'config-entry', 'read', NULL),
				( 'query', 'read', NULL);

CREATE OR REPLACE FUNCTION sf_auth.insert_missing_abilities_for_zone_managers_role(
    _role_id BIGINT
    )
RETURNS VOID as
$$
DECLARE
	_ability_id BIGINT;
BEGIN
	FOR _ability_id IN
		INSERT INTO sf_auth.ability (type, method, value)
		SELECT *
		FROM (SELECT req.type, req.method, req.value
		      FROM required_abilities req
		      EXCEPT
		      SELECT a.type, a.method, a.value
              FROM sf_auth.role r
              JOIN sf_auth.role_ability ra ON r.id = ra.role_id
              JOIN sf_auth.ability a  ON ra.ability_id = a.id
              WHERE r.id = _role_id
		      ) AS missing
		RETURNING id
	LOOP
		INSERT INTO sf_auth.role_ability (role_id, ability_id)
		VALUES (_role_id, _ability_id);
	END LOOP;

END;
$$ LANGUAGE plpgsql SECURITY DEFINER VOLATILE PARALLEL UNSAFE;

SELECT sf_auth.insert_missing_abilities_for_zone_managers_role(r.id)
FROM sf_auth.role r
JOIN sf_auth.role_ability ra ON r.id = ra.role_id
JOIN sf_auth.ability a  ON ra.ability_id = a.id
WHERE r.name LIKE 'zone-%-managers' AND r.name NOT LIKE 'zone-%-restoring-managers'
GROUP BY r.id
HAVING  count(*)<10
ORDER BY r.id, r.name ;

DROP TABLE required_abilities;
