/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

-- A schema for customer-specific tables, views, and functions
-- In tests it might exist to verify that nothing drops it when upgrading
CREATE SCHEMA IF NOT EXISTS sf_local;
DO
$body$
BEGIN
    -- The user is added by post-install scripts thus he is not present when the code is run in tests
    -- other than those that use Starfish installed from packages.
    IF EXISTS (SELECT * FROM pg_catalog.pg_user WHERE usename = 'reports_user') THEN
        GRANT USAGE ON SCHEMA sf_local TO reports_user;
        ALTER DEFAULT PRIVILEGES IN SCHEMA sf_local GRANT SELECT ON TABLES TO reports_user;
    END IF;
END
$body$
LANGUAGE 'plpgsql';
