/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */


CREATE OR REPLACE FUNCTION sf_auth.add_missing_abilities_for_zone_managers_role(
    _role_id BIGINT
    )
RETURNS VOID as
$$
DECLARE
	_ability_id BIGINT;

BEGIN
	FOR _ability_id IN
		INSERT INTO sf_auth.ability (type, "method", value)
		VALUES ( 'license', 'read', null),
				( 'mapping', 'read', null),
				( 'tag', 'read', null),
				( 'fs_entry', 'read', null),
				( 'namespace', 'read', null),
				( 'zone', 'read', null),
				( 'config-entry', 'read', null),
				( 'query', 'read', null)
		RETURNING id
	LOOP
		INSERT INTO sf_auth.role_ability (role_id, ability_id)
		VALUES (_role_id, _ability_id);
	END LOOP;
END;
$$ LANGUAGE plpgsql SECURITY DEFINER VOLATILE PARALLEL UNSAFE;


SELECT sf_auth.add_missing_abilities_for_zone_managers_role(r.id)
FROM sf_auth."role" r
JOIN sf_auth.role_ability ra ON r.id = ra.role_id
JOIN sf_auth.ability a  ON ra.ability_id = a.id
WHERE r."name" LIKE 'zone-%-managers' AND r."name" NOT LIKE 'zone-%-restoring-managers'
GROUP BY r.id
HAVING  count(*)=2
ORDER BY r.id, r."name" ;
