/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

CREATE OR REPLACE FUNCTION quote_table_name(full_table_name TEXT)
  RETURNS TEXT
AS $$
DECLARE
   schema_or_table_name TEXT = '';
   table_name TEXT = '';
BEGIN
    schema_or_table_name := split_part(full_table_name, '.', 1);
    table_name := split_part(full_table_name, '.', 2);
    IF table_name = '' THEN
        RETURN quote_ident(schema_or_table_name);
    ELSE
        RETURN quote_ident(schema_or_table_name) || '.' || quote_ident(table_name);
    END IF;
END;
$$ LANGUAGE plpgsql SECURITY DEFINER IMMUTABLE PARALLEL SAFE;

-- this function must be atomic, as it is used in feeder, which can encounter non-existing fs entry queue
-- that has been just deleted by an another crawler (in many agents scan case)
CREATE OR REPLACE FUNCTION sf.table_exists_and_not_empty(full_table_name TEXT)
  RETURNS BOOL
AS $$
DECLARE
   i BIGINT = 0;
BEGIN
    EXECUTE 'SELECT 1 FROM ' || quote_table_name(full_table_name) || ' LIMIT 1'
    INTO i;
    RETURN i IS NOT NULL;
EXCEPTION WHEN undefined_table THEN
    RETURN FALSE;
END;
$$ LANGUAGE plpgsql SECURITY DEFINER VOLATILE PARALLEL UNSAFE;
