/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

DROP SCHEMA IF EXISTS sf_internal CASCADE;
CREATE SCHEMA sf_internal;


CREATE UNLOGGED TABLE sf_internal.event_base
(
    seq_num BIGINT NOT NULL,
    volume_id BIGINT NOT NULL,
    event_type TEXT NOT NULL,
    type sf.type_t NOT NULL,
    sync_time sf.time_t,
    inode sf.ino_t,
    old_inode sf.ino_t,
    uid sf.uid_t,
    gid sf.gid_t,
    perms sf.perms_t,
    size sf.off_t,
    blocks sf.blkcnt_t,
    nlinks sf.nlinks_t,
    atime sf.time_t,
    mtime sf.time_t,
    ctime sf.time_t,
    depth sf.depth_t,
    path TEXT,
    parent_path TEXT,
    name TEXT,
    target TEXT,
    custom_fs_attrs JSONB,
    local_aggrs JSONB,
    out_of_sync_time sf.time_t,
    tree_out_of_sync_time sf.time_t,
    new_full_path TEXT,
    errors JSONB
);


-- event error table
CREATE TABLE sf_internal.event_error (like sf_internal.event_base);
ALTER TABLE sf_internal.event_error ADD COLUMN error TEXT;
ALTER TABLE sf_internal.event_error ADD COLUMN pipeline_id BIGINT;
