#!/usr/bin/env bash
#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

set -euo pipefail

usage() {
    echo "Usage: $0 [ -AtH ] " 1>&2
    echo "       -A    don't align output (CSV) " 1>&2
    echo "       -t    no header row " 1>&2
    echo "       -H    html format" 1>&2
    echo "       -d    count unqieu dirs only (vs total occurrences in all dirs)" 1>&2
}

OPTS=""

dirs_only=0
while getopts "hHtAd" arg; do
  case $arg in
    h)
      usage
      exit 0
      ;;
    d)
      dirs_only=1
      ;;
    t | A | H )
      OPTS="$OPTS -$arg"
      ;;
    *)
      usage
      exit 2
      ;;
  esac
done
shift $((OPTIND-1))

# OPTS should be expanded as individual options to psql through runquery
#shellcheck disable=SC2086

if [[ ${dirs_only} == 1 ]]; then
    /opt/starfish/bin/tools/runquery -q ${OPTS} -F, --pset=footer -c "
    SELECT v.name as volume,
           key as error,
           count(value) as dir_count
    FROM sf.dir_current
    CROSS JOIN jsonb_each(errors)
    INNER JOIN sf_volumes.volume v ON v.id = volume_id WHERE errors IS NOT NULL
        AND key LIKE 'has%'
    GROUP BY volume, key; "
else
    /opt/starfish/bin/tools/runquery -q ${OPTS} -F, --pset=footer -c "
    SELECT v.name AS volume,
           key AS error,
           sum((value->>0)::BIGINT) AS all_count
    FROM sf.dir_current CROSS JOIN jsonb_each(errors)
    INNER JOIN sf_volumes.volume v ON v.id = volume_id WHERE errors IS NOT NULL
        AND key NOT LIKE 'has%'
    GROUP BY volume, key;"
fi
