/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

/*******************************************************************************************************************************
    Volume Space Prediction
*******************************************************************************************************************************/

CREATE OR REPLACE FUNCTION predict_point(run_time TIMESTAMP WITH TIME ZONE,
                                         slope DOUBLE PRECISION,
                                         intercept DOUBLE PRECISION,
                                         base_time TIMESTAMP WITH TIME ZONE,
                                         basepoint NUMERIC)
RETURNS DOUBLE PRECISION AS $$
DECLARE
   offsetv BIGINT;
   rt bigint := EXTRACT(epoch FROM run_time);
   bt bigint := EXTRACT(epoch FROM base_time);
   predicted DOUBLE PRECISION;
BEGIN
-- offsetv is used to move the start of the line to the most recent datapoint
-- in the report from the current table. Why? Because in a normal use case
-- the customer will have noticed that they are running or about to run out of
-- space and then go on a cleaning spree. So, after we construct the average
-- regression line, this predicts from the most recent (cleaned) point to the future
   offsetv := (slope*bt + intercept) - basepoint;
   predicted := (slope*rt + (intercept - offsetv)) / (1024.0*1024*1024*1024);
   RETURN predicted;
END;
$$ LANGUAGE plpgsql IMMUTABLE PARALLEL SAFE;
