/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
CREATE SCHEMA sf_dispatcher;

CREATE TABLE sf_dispatcher.job
(
  id TEXT NOT NULL,
  name_id BIGINT NOT NULL,
  volume_id BIGINT NOT NULL,
  dst_volume_id BIGINT,
  command JSONB NOT NULL,
  heartbeat TIMESTAMP WITH TIME ZONE NOT NULL,
  status TEXT NOT NULL,
  reason_code TEXT,
  reason_msg TEXT,
  paused_for INTERVAL NOT NULL,
  throttled_for INTERVAL NOT NULL,
  last_dispatcher_operation TEXT,
  estimated_total_entries_num BIGINT,
  estimated_total_bytes BIGINT,
  tags_state TEXT NOT NULL,
  tag_entry_failure_count BIGINT NOT NULL,
  requested_by TEXT NOT NULL,
  prescan_id BIGINT,
  current_incarnation_id INTEGER NOT NULL,
  options JSONB NOT NULL,
  CONSTRAINT job_pkey PRIMARY KEY (id)
);

CREATE TABLE sf_dispatcher.incarnation
(
  job_id TEXT NOT NULL,
  incarnation_id INTEGER NOT NULL,
  from_scratch BOOLEAN NOT NULL,
  cmd_line JSONB NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL,
  started_at TIMESTAMP WITH TIME ZONE,
  prescan_enabled BOOLEAN,
  fs_stats JSONB NOT NULL,
  CONSTRAINT incarnation_pkey PRIMARY KEY (job_id, incarnation_id),
  CONSTRAINT incarnation_job_id_fk FOREIGN KEY (job_id)
      REFERENCES sf_dispatcher.job (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
);

CREATE INDEX job_name_id ON sf_dispatcher.job(name_id);
CREATE INDEX job_reason_code ON sf_dispatcher.job(reason_code );
CREATE INDEX job_status ON sf_dispatcher.job(status);
CREATE INDEX job_volume_id ON sf_dispatcher.job(volume_id);
CREATE INDEX job_dst_volume_id ON sf_dispatcher.job(dst_volume_id);
CREATE INDEX job_dst_path ON sf_dispatcher.job((options ->> 'dst_path'));
CREATE INDEX job_root_path ON sf_dispatcher.job((options ->> 'root_path'));
CREATE INDEX job_heartbeat ON sf_dispatcher.job(heartbeat);
