/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

DO $$
  DECLARE
    manage_files_ability RECORD;
    manage_user_params_ability RECORD;
    ra RECORD;
  BEGIN
    FOR manage_files_ability IN (
      SELECT * FROM sf_auth.ability WHERE method = 'manage-files' AND value not in (
        SELECT value FROM sf_auth.ability WHERE method = 'manage-zone-user-params'
      )
    )
    LOOP
      INSERT INTO sf_auth.ability (type, method, value)
      VALUES ('zone', 'manage-zone-user-params', manage_files_ability.value)
      RETURNING * INTO manage_user_params_ability;
      FOR ra IN (
        SELECT * FROM sf_auth.role_ability WHERE ability_id = manage_files_ability.id
      )
      LOOP
        INSERT INTO sf_auth.role_ability (role_id, ability_id) VALUES (ra.role_id, manage_user_params_ability.id);
      END LOOP;
    END LOOP;
  END
$$;
