#!/opt/starfish/examples/venv/bin/python3
"""
***********************************************************************************************************

 Starfish Storage Corporation ("Starfish") CONFIDENTIAL
 Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.

 NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
 Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
 intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
 U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
 Dissemination of this information or reproduction of this material is strictly forbidden unless prior
 written permission is obtained from Starfish. Access to the source code contained herein is hereby
 forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
 confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
 Starfish's software.

 ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
 THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
 AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
 FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
 DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
 WHOLE OR IN PART.

 FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
   These notices shall be marked on any reproduction of this data, in whole or in part.
   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
   Software clause at DFARS 52.227-7013.

***********************************************************************************************************
"""
# ********************************************************
#  Author Doug Hughes
#  Last modified 2023-02-10
#
#  2023-02-10 remove direct SQL querying, make this script a wrapper around `sf query`
#  2020-05-19 cleanup syntax and output hash based upon input hash
#
# simple script to pull all objects matching a hash (basically a wrapper around a query)

import argparse
import os
import shlex
import sys


def main():
    # Parse Arguments
    descr = (
        "This is a fast database way to find all of the files matching "
        "a specific hash of either MD5 or SHA1 type. It can also output "
        "in csv/tsv format.  It's useful to gain an understanding "
        "of how lobs, directories, files, and volumes link together. "
        "it also is slightly easier to understand than using the sf "
        "query syntax to get hashes which involves using --jobs."
    )
    parser = argparse.ArgumentParser(description=descr)
    parser.add_argument(
        "--csv", action="store_true", default=False, help="output in a csv format with a comma separator"
    )
    parser.add_argument(
        "--delimiter", required=False, metavar="SEP", default=" ", help="an optional output field separator"
    )
    parser.add_argument("--volume", required=False, help="an optional volume to constrain the query")
    parser.add_argument("--hash", required=True, help="An MD5 or SHA1 hash")
    parser.add_argument(
        "--type",
        required=False,
        choices=["md5", "sha1"],
        default="sha1",
        help="Must be literally sha1 or md5, default is sha1",
    )
    parser.add_argument("--debug", action="store_true", required=False)

    args = parser.parse_args()

    cmdline = ["sf", "query"]
    if args.volume:
        cmdline += [f"{args.volume}:"]

    cmdline += ["--delimiter", args.delimiter]
    if args.csv:
        cmdline += ["--csv"]
    cmdline += ["--no-headers"]
    cmdline += ["--type", "f", f"--jobs.hash.{args.type}={args.hash}"]
    cmdline += ["--format", f"jobs.hash.result.{args.type} volume mount_path size"]

    if args.debug:
        print(" ".join(shlex.quote(el) for el in cmdline))
    os.execvp("sf", cmdline)


if __name__ == "__main__":
    sys.exit(main())
