#!/opt/starfish/examples/venv/bin/python3
"""
***********************************************************************************************************

 Starfish Storage Corporation ("Starfish") CONFIDENTIAL
 Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.

 NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
 Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
 intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
 U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
 Dissemination of this information or reproduction of this material is strictly forbidden unless prior
 written permission is obtained from Starfish. Access to the source code contained herein is hereby
 forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
 confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
 Starfish's software.

 ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
 THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
 AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
 FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
 DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
 WHOLE OR IN PART.

 FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
   These notices shall be marked on any reproduction of this data, in whole or in part.
   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
   Software clause at DFARS 52.227-7013.

***********************************************************************************************************
"""
###############################################################################
#  Author Doug Hughes
#  Last modified 2019-04-19
#
# Run simple sql queries while removing the need to find the auth key or
# format the query
# This query outputs the query results, whatever they are, in a CSV output
# format. It does not currently take care of quoting.
#
# 2018-08-27 - add html table support
#
# WARNING: This script runs queries directly against the Starfish database.
# It could be used to cause tremendous harm and render Starfish inoperable if
# used incorrectly. It is recommended to only run select and not update queries.

import os
import re
import sys
import unittest

try:
    import argparse
    import configparser

    import psycopg2
except Exception:
    print(
        "In order to use this, you must have configparser, argparse, "
        "and psycopg2 modules installed (available via pip among "
        "other means.)"
    )
    sys.exit(1)


class TestQ(unittest.TestCase):
    """extension for unittest framework."""

    def setUp(self):
        pass

    def test_auth(self):
        """test connection"""
        conn = psycopg2.connect(getpgauth())
        self.assertNotEqual(conn, None)

    def test_query(self):
        """test sql return"""
        conn = psycopg2.connect(getpgauth())
        query = """select count(*) from sf_volumes.volume"""
        cur = conn.cursor()
        cur.execute(query)
        self.assertNotEqual(cur, None)
        rows = cur.fetchall()
        self.assertEqual(len(rows), 1)


def getpgauth():
    """pull auth info from config file to use implicitly"""
    try:
        config = configparser.ConfigParser()
        config.read("/opt/starfish/etc/99-local.ini")
        return config.get("pg", "pg_uri")
    except OSError:
        print("can't read config file to get connection uri. check permissions.")
        sys.exit(1)


# ################## main ######################

if __name__ == "__main__":
    inipath = "/opt/starfish/etc/99-local.ini"

    if not os.access(inipath, os.R_OK):
        print(inipath + " is not readable. Try as root")
        sys.exit(1)

    try:
        conn = psycopg2.connect(getpgauth())
    except psycopg2.DatabaseError as e:
        print("unable to connect to the database: {}".format(str(e)))
        sys.exit(1)

    # Parse Arguments
    descr = """
               find directories without anything in them. It is recommended that
               this be run with --debug 1 first just to see what would have been
               done. """

    parser = argparse.ArgumentParser(description=descr)
    parser.add_argument("--debug", type=int, default=0, required=False, help="add some debugging to output")
    parser.add_argument("--volume", required=True, help="limit checking to a volume")
    parser.add_argument("--test", action="store_true", required=False, help=argparse.SUPPRESS)
    parser.parse_args()

    args = parser.parse_args()

    if args.test:
        unittest.main(argv=["first-arg-is-ignored"], exit=True)

    cur = conn.cursor()

    q1 = (
        """
    SELECT dir.path
    FROM sf.dir_current dir
    INNER JOIN sf_volumes.volume volume ON volume.id = dir.volume_id
    WHERE (dir.local_aggrs->'total'->>'dirs')::BIGINT = 0
    AND (dir.local_aggrs->'total'->>'files')::BIGINT = 0
    AND volume.name = '%s'
    """  # noqa: S001
        % args.volume
    )

    if args.debug:
        print("executing query " + q1)

    cur.execute(q1)

    rows = cur.fetchall()

    skip = re.compile(r"\.snapshot|lost\+found|tmp|temp")

    for row in rows:
        if skip.match(row[0]):
            continue
        if args.debug:
            print("rmdir " + row[0])
        else:
            os.removedirs(row[0])

    sys.exit(0)
