#!/usr/bin/env bash
#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

set -euo pipefail

readonly CP="$(command -v gcp 2>&1 || command -v cp 2>&1)"
readonly FIND="$(command -v gfind 2>&1 || command -v find 2>&1)"
readonly SED="$(command -v gsed 2>&1 || command -v sed 2>&1)"

readonly SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
readonly SCRIPT_BASENAME="$(basename "${BASH_SOURCE[0]}")"

readonly SFX_DIR="${SCRIPT_DIR}/../../../sf-packaging/sfx"
readonly STARFISH_VERSION_FILE="${SCRIPT_DIR}/../../starfish/version"

readonly SFX_SCRIPTS="$(mktemp --directory --tmpdir sf-create-self-extractor.XXXXXXX)"

remove_temp_dir() {
    rm -rf -- "${SFX_SCRIPTS}"
}
trap remove_temp_dir EXIT

if [ -r "${STARFISH_VERSION_FILE}" ]; then
    # this one will work in production
    readonly VERSION="$(cat "${STARFISH_VERSION_FILE}")"
else
    # this one will work in development when run in git repo
    readonly VERSION="$(git describe --always --dirty --long | ${SED} -r 's/-([0-9]+)-(g.+)/.post\1+\2/g' | ${SED} 's/-dirty/.dirty/g')"
fi

${CP} -a "${SCRIPT_DIR}"/* "${SFX_SCRIPTS}"
rm -f -- "${SFX_SCRIPTS}/${SCRIPT_BASENAME}"
${FIND} "${SFX_SCRIPTS}" -type f -exec "${SED}" -i "s/INSTALL_SCRIPT_VERSION=.*/INSTALL_SCRIPT_VERSION=${VERSION}/g" {} \;

OUTPUT_NAME="install-Starfish.sh"
"${SFX_DIR}/create-sfx.sh" "${OUTPUT_NAME}" install.sh "${SFX_SCRIPTS}"

echo "Starfish installer ${VERSION} created in ${OUTPUT_NAME}"
