#!/usr/bin/env bash
#***********************************************************************************************************
#
# Starfish Storage Corporation ("Starfish") CONFIDENTIAL
# Unpublished Copyright (c) 2011 - present Starfish Storage Corporation, All Rights Reserved.
#
# NOTICE: This file and its contents (1) constitute Starfish's "External Code" under Starfish's most-recent
# Limited Software End-User License Agreement, and (2) is and remains the property of Starfish. The
# intellectual and technical concepts contained herein are proprietary to Starfish and may be covered by
# U.S. and/or foreign patents or patents in process, and are protected by trade secret or copyright law.
# Dissemination of this information or reproduction of this material is strictly forbidden unless prior
# written permission is obtained from Starfish. Access to the source code contained herein is hereby
# forbidden to anyone except (A) current Starfish employees, managers, or contractors who have executed
# confidentiality or nondisclosure agreements explicitly covering such access, and (B) licensees of
# Starfish's software.
#
# ANY REPRODUCTION, COPYING, MODIFICATION, DISTRIBUTION, PUBLIC PERFORMANCE, OR PUBLIC DISPLAY OF OR
# THROUGH USE OF THIS SOURCE CODE WITHOUT THE EXPRESS WRITTEN CONSENT OF STARFISH IS STRICTLY PROHIBITED
# AND IS IN VIOLATION OF APPLICABLE LAWS AND INTERNATIONAL TREATIES. THE RECEIPT OR POSSESSION OF THIS
# FILE OR ITS CONTENTS AND/OR RELATED INFORMATION DOES NOT CONVEY OR IMPLY ANY RIGHTS TO REPRODUCE,
# DISCLOSE, OR DISTRIBUTE ITS CONTENTS, OR TO MANUFACTURE, USE, OR SELL ANYTHING THAT IT MAY DESCRIBE, IN
# WHOLE OR IN PART.
#
# FOR U.S. GOVERNMENT CUSTOMERS REGARDING THIS DOCUMENTATION/SOFTWARE
#   These notices shall be marked on any reproduction of this data, in whole or in part.
#   NOTICE: Notwithstanding any other lease or license that may pertain to, or accompany the delivery of,
#   this computer software, the rights of the Government regarding its use, reproduction and disclosure are
#   as set forth in Section 52.227-19 of the FARS Computer Software-Restricted Rights clause.
#   RESTRICTED RIGHTS NOTICE: Use, duplication, or disclosure by the Government is subject to the
#   restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer
#   Software clause at DFARS 52.227-7013.
#
#***********************************************************************************************************

set -euo pipefail

INSTALL_PARAMS_SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
readonly INSTALL_PARAMS_SCRIPT_DIR

# shellcheck source=scripts/installation/_pg_common.sh
source "${INSTALL_PARAMS_SCRIPT_DIR}/_pg_common.sh"

# shellcheck source=scripts/installation/_redash_common.sh
source "${INSTALL_PARAMS_SCRIPT_DIR}/_redash_common.sh"

export SFHOME=${SFHOME:-/opt/starfish}
export STARFISH_BIN_DIR=${SFHOME}/bin
export STARFISH_ETC_DIR=${SFHOME}/etc
export STARFISH_ETC_LOCAL_INI="${STARFISH_ETC_DIR}/99-local.ini"
export STARFISH_ETC_SECRETS_INI="${STARFISH_ETC_DIR}/95-secrets.ini"
export STARFISH_ETC_SERVICE_INI="${STARFISH_ETC_DIR}/01-service.ini"
export STARFISH_PG_DIR=${SFHOME}/pg
export STARFISH_REDASH_DIR=${SFHOME}/redash-systemd

get_default_arg_values_path() {
    local directory
    directory="$(readlink --canonicalize-existing --verbose "${HOME:-/root}")/.starfish"  # quoted tilde is not expanded

    mkdir --parents "${directory}"
    echo "${directory}/installation-defaults"
}

read_default_arg_values() {
    local path
    path="$(get_default_arg_values_path)"

    if file_readable "${path}"; then
        log "Reading installation params from ${path}"
        # shellcheck source=/dev/null
        source "${path}" || true  # calling script shouldn't break because of corrupted defaults
    else
        log "Did not read installation params from ${path}: not readable"
    fi
}

write_default_arg_values() {
    local defaults="" path name val

    while [ $# -gt 0 ]; do
        name=$1
        shift
        val=$1
        shift
        defaults="${defaults}${name}='${val}'\\n"
    done

    path="$(get_default_arg_values_path)"

    log "Writing installation params to ${path}"
    echo -e "${defaults}" > "${path}"
    chmod 600 "${path}"
}

load_default_installation_params() {
    DEFAULT_SF_REPO_URL=""
    DEFAULT_SF_LISTEN_ADDRESS="$(get_hostname)"
    DEFAULT_SF_CONTINUE_ON_PROXY="no"
    DEFAULT_SF_DB_PATH="${STARFISH_PG_DIR}/${STARFISH_PG_VERSION}"
    DEFAULT_SF_DB_STORAGE_TYPE="$(get_default_db_storage_type)"
    DEFAULT_SF_CONFIGURE_BACKUP="no"
    DEFAULT_SF_BACKUP_PATH="$(get_default_pgbackup_path)"
    DEFAULT_SF_BACKUP_RETENTION="2"
    DEFAULT_SF_ENABLE_DIAG="yes"
    DEFAULT_SF_SEND_DIAG_TO_SF="yes"
    DEFAULT_SF_ATTACH_JSON_TO_EMAIL="yes"
    DEFAULT_SF_OBFUSCATE_CONFIDENTIAL_INFO="no"
    DEFAULT_SF_DIAG_FROM_EMAIL=""
    DEFAULT_SF_DIAG_EXTRA_EMAILS_ERRORS_ONLY=""
    DEFAULT_SF_DIAG_EXTRA_EMAILS=""
    DEFAULT_SF_DIAG_IGNORED_ERRORS_PATTERN=""
    DEFAULT_REDASH_LISTEN_PORT="80"
    DEFAULT_REDASH_EMAIL="${REDASH_DEFAULT_EMAIL}"

    read_default_arg_values

    # in older Starfish versions starfish's listen address was stored in DEFAULT_SF_LISTEN_IP
    # if we load installation parameters from older version of starfish we have to load IP address
    # from this variable (see STAR-6294).
    DEFAULT_SF_LISTEN_ADDRESS="${DEFAULT_SF_LISTEN_IP:-${DEFAULT_SF_LISTEN_ADDRESS}}"
}

load_default_installation_params_for_existing_installation() {
    load_default_installation_params
    if [[ "${DEFAULT_SF_DB_PATH}" == "${STARFISH_PG_DIR}/${STARFISH_PG_VERSION}" ]] \
            && ! dir_exists "${DEFAULT_SF_DB_PATH}" \
            && dir_exists "${STARFISH_PG_DIR}/9.6"; then
        # fallback if existing installation with PG 9.6 and file with default values isn't accessible
        DEFAULT_SF_DB_PATH="${STARFISH_PG_DIR}/9.6"
    fi
}

save_default_installation_params() {
    # has to be called after load_default_installation_params
    # if given parameter e.g. SF_REPO_URL not set, write loaded default value
    write_default_arg_values \
        DEFAULT_SF_REPO_URL "${SF_REPO_URL:-${DEFAULT_SF_REPO_URL}}" \
        DEFAULT_SF_LISTEN_ADDRESS "${SF_LISTEN_ADDRESS:-${DEFAULT_SF_LISTEN_ADDRESS}}" \
        DEFAULT_SF_DB_PATH "${SF_DB_PATH:-${DEFAULT_SF_DB_PATH}}" \
        DEFAULT_SF_CONTINUE_ON_PROXY "${SF_CONTINUE_ON_PROXY:-${DEFAULT_SF_CONTINUE_ON_PROXY}}" \
        DEFAULT_SF_DB_STORAGE_TYPE "${SF_DB_STORAGE_TYPE:-${DEFAULT_SF_DB_STORAGE_TYPE}}" \
        DEFAULT_SF_CONFIGURE_BACKUP "${SF_CONFIGURE_BACKUP:-${DEFAULT_SF_CONFIGURE_BACKUP}}" \
        DEFAULT_SF_BACKUP_PATH "${SF_BACKUP_PATH:-${DEFAULT_SF_BACKUP_PATH}}" \
        DEFAULT_SF_BACKUP_RETENTION "${SF_BACKUP_RETENTION:-${DEFAULT_SF_BACKUP_RETENTION}}" \
        DEFAULT_SF_ENABLE_DIAG "${SF_ENABLE_DIAG:-${DEFAULT_SF_ENABLE_DIAG}}" \
        DEFAULT_SF_SEND_DIAG_TO_SF "${SF_SEND_DIAG_TO_SF:-${DEFAULT_SF_SEND_DIAG_TO_SF}}" \
        DEFAULT_SF_ATTACH_JSON_TO_EMAIL "${SF_ATTACH_JSON_TO_EMAIL:-${DEFAULT_SF_ATTACH_JSON_TO_EMAIL}}" \
        DEFAULT_SF_OBFUSCATE_CONFIDENTIAL_INFO "${SF_OBFUSCATE_CONFIDENTIAL_INFO:-${DEFAULT_SF_OBFUSCATE_CONFIDENTIAL_INFO}}" \
        DEFAULT_SF_DIAG_EXTRA_EMAILS_ERRORS_ONLY "${SF_DIAG_EXTRA_EMAILS_ERRORS_ONLY:-${DEFAULT_SF_DIAG_EXTRA_EMAILS_ERRORS_ONLY}}" \
        DEFAULT_SF_DIAG_EXTRA_EMAILS "${SF_DIAG_EXTRA_EMAILS:-${DEFAULT_SF_DIAG_EXTRA_EMAILS}}" \
        DEFAULT_SF_DIAG_FROM_EMAIL "${SF_DIAG_FROM_EMAIL:-${DEFAULT_SF_DIAG_FROM_EMAIL}}" \
        DEFAULT_SF_DIAG_IGNORED_ERRORS_PATTERN "${SF_DIAG_IGNORED_ERRORS_PATTERN:-${DEFAULT_SF_DIAG_IGNORED_ERRORS_PATTERN}}" \
        DEFAULT_REDASH_LISTEN_PORT "${REDASH_LISTEN_PORT:-${DEFAULT_REDASH_LISTEN_PORT}}" \
        DEFAULT_REDASH_EMAIL "${REDASH_EMAIL:-${DEFAULT_REDASH_EMAIL}}"
}
