/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
 -- tag_details_drilldown_redash_query.sql
 -- zone_details_drilldown_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

-- TODO STAR-7464 Revert this link after the task is done
-- SELECT '<a href="queries/QUERY_ID_FOR_REPORT(top_directories_within_zone_tag)?p_zone='||zone||'&p_tagset='||namespace||'&p_tag='||tag||'">'||zone||'/'||namespace||':'||tag||'</a>' AS "zone/tag",
SELECT zone||'/'||namespace||':'||tag AS "zone/tag",
       COALESCE(volume.display_name, zone_namespace_tags_current.volume_name) AS volume,
       SUM(size) / (1024 * 1024 * 1024.0) AS "logical size (GiB)",
       SUM(physical_size) / (1024 * 1024 * 1024.0) AS "physical size (GiB)",
       SUM(count)::BIGINT AS "count",
       TRUNC(SUM(cost)::NUMERIC, 2) AS "cost",
       MAX(run_time) AS "update time"
FROM sf_reports.zone_namespace_tags_current AS zone_namespace_tags_current
    LEFT JOIN sf_volumes.volume ON zone_namespace_tags_current.volume_name = volume.name
WHERE zone = '{{{zone}}}'
AND namespace = '{{{tagset}}}'
AND tag = '{{{tag}}}'
GROUP BY zone, namespace, tag, volume
ORDER BY zone, namespace, tag, volume
