/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
-- similar to:
-- tag_details_drilldown_redash_query.sql
-- zone_tag_details_drilldown_redash_query.sql
-- whenever someone changes this file changing the ones above should also be considered

SELECT zone.name AS "zone",
       SUM(size) / (1024 * 1024 * 1024.0) AS "logical size (GiB)",
       SUM(physical_size) / (1024 * 1024 * 1024.0) AS "physical size (GiB)",
       SUM(count)::BIGINT AS "count",
       run_time
FROM sf_reports.tags_history AS tags_history
     JOIN sf_auth.zone ON SUBSTRING(tags_history.tag, length('__zone:')+1) = zone.id::VARCHAR
WHERE SUBSTRING(tags_history.tag, 1, length('__zone:')) = '__zone:'
GROUP BY zone.name, run_time
ORDER BY zone.name, run_time
