/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH zone_root_dirs AS (
    SELECT
        tvc.volume_id,
        d.id AS dir_id,
        d.path
    FROM sf.tag_value_current tvc
    INNER JOIN sf.tag_name tn ON tvc.name_id = tn.id
    INNER JOIN sf.tag_namespace space ON tn.namespace_id = space.id
    INNER JOIN sf.dir_current d ON tvc.fs_entry_id = d.id
    JOIN sf_auth.zone zname ON tn.name = zname.id::VARCHAR
    WHERE space.name = '__zone'
    AND zname.name = '{{zone}}'
), zone_dirs AS (
    SELECT
        d.volume_id AS volume_id,
        d.id AS dir_id,
        d.path AS path,
        d.depth AS depth,
        d.rec_aggrs AS rec_aggrs
    FROM zone_root_dirs zd
    INNER JOIN sf.dir_current d ON d.volume_id = zd.volume_id
        AND (d.path = zd.path OR d.path LIKE subtree_pattern(zd.path))
    WHERE d.depth <= {{max_depth}}
    ORDER BY d.rec_aggrs->>'size' DESC
    LIMIT {{number_of_rows}}
)
SELECT
    vol.name AS "volume",
    '/' || dir.path AS "path",
    ROUND((dir.rec_aggrs->>'size')::DECIMAL / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
    ROUND((COALESCE(rec_aggrs->>'blocks_div_nlinks', rec_aggrs->>'blocks')::BIGINT * 512)::DECIMAL / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)",
    (dir.rec_aggrs->>'files')::BIGINT as "file count",
    (dir.rec_aggrs->>'dirs')::BIGINT as "subdirectory count"
FROM zone_dirs dir
INNER JOIN sf_volumes.volume vol ON vol.id = dir.volume_id
ORDER BY "logical size (GiB)" DESC
