/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT
    '<a href="DASHBOARD_LINK(volume-detail-analytics)?p_volume='|| stats_current."volume name" || '">' ||
        CASE
            WHEN volume.name IS NULL THEN
                'REMOVED:  '
            ELSE
                ''
        END || COALESCE(volume.display_name, stats_current."volume name") || '</a>' AS "volume name",
    ROUND("total capacity" / (1024 * 1024 * 1024.0), 2) AS "capacity (GiB)",
    ROUND("volume occupied space" / (1024 * 1024 * 1024.0), 2) AS "used physical (GiB)",
    ROUND("volume occupied space logical" / (1024 * 1024 * 1024.0), 2) AS "used logical (GiB)",
    ROUND("volume free space" / (1024 * 1024 * 1024.0), 2) AS "free (GiB)",
    "volume occupied space %" AS "used %",
    "regular files",
    "symbolic links",
    ROUND("maximum file size" / (1024 * 1024 * 1024.0), 2) AS "max file size (GiB)",
    "median file size" AS "median file size (bytes)",
    ROUND("average file size")::BIGINT AS "average file size (bytes)",
    "directories",
    "directories without files" AS "directories with subdirectories only",
    "empty directories",
    ROUND("maximum directory non-recursive size" / (1024 * 1024 * 1024.0), 2) AS "max dir size (GiB)"
FROM sf_reports.stats_current
    LEFT JOIN sf_volumes.volume AS volume ON stats_current."volume name" = volume.name
