/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH old_files AS (
    SELECT
        f.parent_id AS parent_id,
        ROUND(SUM(f.blocks * 512 / CASE WHEN f.nlinks > 0 THEN f.nlinks ELSE 1 END) / (1024 * 1024 * 1024.0), 2) AS size_of_old_files_gib,
        COUNT(*) as count
    FROM sf.file_current AS f
    WHERE f.atime < (now()::DATE - INTERVAL '{{number_of_years_old}} years')
        AND f.volume_id = sf.volume_id_from_name('{{volume}}')
    GROUP BY f.parent_id
    ORDER BY size_of_old_files_gib DESC, count DESC
    LIMIT {{number_of_rows}}
) SELECT v.name AS volume,
       d.path AS dir,
       CASE
           WHEN u.name IS NOT NULL THEN u.name
           ELSE d.uid::TEXT
       END AS "dir owner",
  f.size_of_old_files_gib AS "size of old files (GiB)",
  f.count AS "number of old files",
  (d.local_aggrs->'total'->>'files')::BIGINT AS "total number of files",
  ROUND(100.0 * count / (d.local_aggrs->'total'->>'files')::BIGINT, 1) AS "% of old files"
FROM old_files AS f
    INNER JOIN sf.dir_current d ON f.parent_id = d.id
    INNER JOIN sf_volumes.volume v ON d.volume_id=v.id
    LEFT JOIN sf.uid_mapping u ON d.uid = u.uid AND d.volume_id = u.volume_id
WHERE d.volume_id = sf.volume_id_from_name('{{volume}}');
