/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH top_users AS (
    SELECT uid
    FROM sf_reports.last_time_generic_current
    GROUP BY uid
    ORDER BY MAX(user_total_size) DESC
    LIMIT 20
)

SELECT
    ltgh.user_name,
    ltgh.uid,
    ltgh.run_time,
    MAX(ltgh.user_total_size) / (1024::BIGINT * 1024 * 1024 * 1024) AS user_size_TiB
FROM sf_reports.last_time_generic_history ltgh
INNER JOIN top_users tu ON tu.uid = ltgh.uid
WHERE run_time > NOW() - INTERVAL '{{newer_than}}'
GROUP BY ltgh.user_name, ltgh.uid, ltgh.run_time
