/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT COALESCE(volume.display_name, extensions_current.volume_name) AS volume_name,
       ext,
       size_all_volumes_ext,
       size_volume_ext,
       physical_size_all_volumes_ext,
       physical_size,
       count_all_volumes_ext,
       count_volume_ext,
       percent_of_whole_volume,
-- THIS IS HACK - Adding ext column with hidden HTML with number
-- Combined with "sort by X values" in redash forces correct column order on chart
    '<b style="display: none !important" class="hidden">'
        || LPAD((DENSE_RANK() OVER(ORDER BY physical_size_all_volumes_ext ASC, size_all_volumes_ext ASC))::text, 5, '0')
        || '</b>'
        || ext as ext_html,
      ROUND(COALESCE(physical_size, size_volume_ext) / (1024 * 1024 * 1024.0), 2) AS size_gib_for_chart
FROM sf_reports.extensions_current
    LEFT JOIN sf_volumes.volume ON extensions_current.volume_name = volume.name
ORDER BY ext_html DESC
