/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT
    "volume name",
    ROUND(SUM((u.value::FLOAT * "volume occupied space") / (1000 * 1000 * 1000.0))::NUMERIC, 2) AS "Cost",
    ROUND(SUM((u.value::FLOAT * "volume free space") / (1000 * 1000 * 1000.0))::NUMERIC, 2) AS "Cost of Unused Space",
    ROUND(((SUM(u.value::FLOAT * "volume occupied space") + SUM(u.value::FLOAT * "volume free space")) /
    (1000 * 1000 * 1000.0))::NUMERIC, 2) AS "Total Cost",
    SUM(ROUND("total capacity" / (1024 * 1024 * 1024.0), 2)) AS "Capacity (GiB)",
    SUM(ROUND("volume occupied space" / (1024 * 1024 * 1024.0), 2)) AS "Used physical (GiB)",
    SUM(ROUND("volume occupied space logical" / (1024 * 1024 * 1024.0), 2)) AS "Used logical (GiB)",
    SUM("volume occupied space") * 100 / SUM("total capacity") AS "Used %",
    SUM(ROUND("volume free space" / (1024 * 1024 * 1024.0), 2)) AS "Free (GiB)",
    SUM("regular files")::BIGINT AS "Regular Files",
    SUM("symbolic links")::BIGINT AS "Symbolic Links",
    MAX(ROUND("maximum file size" / (1024 * 1024 * 1024.0), 2)) AS "max file size (GiB)",
    SUM("directories")::BIGINT AS "Directories",
    MAX(ROUND("maximum directory non-recursive size" / (1024 * 1024 * 1024.0), 2)) AS "max dir size (GiB)"
FROM sf_reports.stats_current s
JOIN sf_volumes.volume v ON v.name = "volume name"
JOIN sf_volumes.user_param u ON v.id = u.volume_id
WHERE u.name = 'cost_per_gb'
GROUP BY "volume name"
ORDER BY "Cost" DESC, "volume name" ASC
LIMIT 20
