/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT COALESCE(volume.display_name, volume.name) AS volume_name,
       scan.creation_time AS creation_time,
       CASE EXTRACT ('epoch' FROM scan.heartbeat - scan.creation_time)
           WHEN 0 THEN 0
           ELSE ROUND((stats->>'lstat')::DECIMAL/EXTRACT ('epoch' FROM crawler.heartbeat - scan.creation_time))
       END AS rate
FROM sf_scans.scan AS scan
    JOIN sf_scans.crawler_info crawler ON (scan.id=crawler.scan_id)
    JOIN sf_volumes.volume volume ON (scan.volume_id = volume.id)
WHERE scan.state_name = 'done' AND scan.type IN ('diff', 'sync') AND scan.creation_time >= NOW() - INTERVAL '6 MONTH'
ORDER BY crawler.heartbeat DESC
