/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT COALESCE(volume.display_name, volume.name) AS volume,
       creation_time at time zone current_setting('TIMEZONE') AS Start_time,
       date_trunc('second', GREATEST(loader_info.heartbeat, scan.heartbeat) - creation_time)
        ||' ('
        || date_trunc('second', scan.heartbeat - creation_time)
        || ')' AS "run_time (scan)",
       scan.TYPE,
       state_name AS STATE,
       reason,
       reason_msg,
       scan.name
FROM sf_scans.scan AS scan,
     sf_volumes.volume AS volume,
     sf_scans.loader_info AS loader_info
WHERE scan.volume_id = volume.id
  AND loader_info.scan_id = scan.id
ORDER BY creation_time DESC
LIMIT 30
