/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
WITH last_scans_per_vol AS (
    SELECT DISTINCT ON (volume_id)
        *
    FROM sf_scans.scan s
    ORDER BY volume_id, heartbeat DESC
)
SELECT
    v.name AS volume,
    last_scan.name AS "scan",
    last_scan.creation_time::TIMESTAMP::DATE AS "started",
    last_scan.state_name AS "state",
    last_scan.heartbeat::TIMESTAMP::DATE AS "last updated"
FROM last_scans_per_vol last_scan
RIGHT JOIN sf_volumes.volume v ON last_scan.volume_id = v.id
WHERE (last_scan.heartbeat IS NULL OR last_scan.heartbeat < NOW() - INTERVAL '{{days}} days')
