/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT
       COALESCE(volume.display_name, volume.name) AS volume,
       '<b style="display: none !important" class="hidden">'
        || LPAD((DENSE_RANK() OVER(ORDER BY CAST (user_param.value AS DOUBLE PRECISION) ASC))::text, 10, '0')
        || '</b>' || user_param.value AS "cost per GB"
FROM sf_volumes.volume AS volume,
     sf_volumes.user_param AS user_param
WHERE user_param.name = 'cost_per_gb'
  AND volume.id = user_param.volume_id
  ORDER BY 1 DESC
