/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH volumes AS (
    SELECT
        volume_name,
        SUM(size)::BIGINT AS size,
        SUM(physical_size)::BIGINT AS physical_size,
        SUM(count)::BIGINT AS files
    FROM sf_reports.last_time_generic_current
    GROUP BY volume_name
)

SELECT
    vol.name AS name,
    ROUND(SUM(ltgc.size) / (1024.0 * 1024 * 1024), 2) AS group_logical_size,
    CASE WHEN SUM(vol_stats.size) = 0 THEN 0
    ELSE ROUND(100 * SUM(ltgc.size) / vol_stats.size, 2)
    END AS logical_size_percentage,
    ROUND(SUM(ltgc.physical_size) / (1024.0 * 1024 * 1024), 2) AS group_physical_size,
    CASE WHEN SUM(vol_stats.physical_size) = 0 THEN 0
    ELSE ROUND(100 * SUM(ltgc.physical_size) / vol_stats.physical_size, 2)
    END AS physical_size_percentage,
    SUM(ltgc.count)::BIGINT AS group_files,
    CASE WHEN SUM(vol_stats.files) = 0 THEN 0
    ELSE ROUND((SUM(ltgc.count) / vol_stats.files) * 100, 2)
    END AS files_percentage
FROM sf.gid_mapping gidm
INNER JOIN sf_volumes.volume vol ON vol.id = gidm.volume_id
LEFT JOIN volumes vol_stats ON vol_stats.volume_name = vol.name
LEFT JOIN sf_reports.last_time_generic_current ltgc ON ltgc.volume_name = vol.name
                                                   AND ltgc.gid = gidm.gid
                                                   AND ltgc.group_name = gidm.name
WHERE gidm.name = '{{groupname}}' AND vol.default_agent_address = '{{agent_address}}'
GROUP BY vol.id, vol.name, vol_stats.files, vol_stats.size, vol_stats.physical_size
ORDER BY vol.name, vol.id
