/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */
SELECT
    v.name AS volume,
    d.path || '/' || f.name AS path,
    u2.name AS dir_owner,
    ROUND(f.size / (1024 * 1024 * 1024.0), 2) AS size_GiB
FROM sf.dir_current d
INNER JOIN sf.file_current f ON d.id = f.parent_id AND d.volume_id = f.volume_id
INNER JOIN sf_volumes.volume v on v.id = d.volume_id
INNER JOIN sf.uid_mapping u on v.id = u.volume_id AND u.uid = f.uid
INNER JOIN sf.uid_mapping u2 on v.id = u2.volume_id AND u2.uid = d.uid
WHERE f.uid != d.uid
AND u.name = '{{username}}'
ORDER BY size_GiB DESC
LIMIT 1000
