/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT CONCAT(schemaname, '.', tablename) AS "partition",
       CONCAT(schemaname, '.', REGEXP_REPLACE(tablename, '_part_[0-9]+', '')) AS "parent table",
       PG_TABLE_SIZE(CONCAT(schemaname, '.', tablename)) AS "data size",
       PG_TOTAL_RELATION_SIZE(CONCAT(schemaname, '.', tablename)) AS "total size"
FROM pg_tables
WHERE schemaname LIKE 'sf%' AND tablename ~ '_part_[0-9]+$'
ORDER BY PG_TOTAL_RELATION_SIZE(CONCAT(schemaname, '.', tablename)) DESC, schemaname, tablename
