/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH volume AS (
    SELECT id
    FROM sf_volumes.volume
    WHERE name = '{{volume}}'
), files AS (
    SELECT
        volume_id,
        name,
        parent_id
    FROM sf.file_current
    WHERE ('{{volume}}' = '*' OR volume_id = (SELECT id FROM volume))
      AND name !~ '[^.]\.[^.]'
),
volume_info AS (
    SELECT
        id AS vol_id,
        default_agent_address AS agent
    FROM sf_volumes.volume
    WHERE '{{volume}}' = '*' OR name = '{{volume}}'
)

SELECT get_full_sys_path(mount.path, dir.path, file.name) AS path
FROM files file
LEFT JOIN sf.dir_current dir ON dir.volume_id = file.volume_id AND dir.id = file.parent_id
LEFT JOIN volume_info vol ON vol.vol_id = file.volume_id
LEFT JOIN sf_volumes.mount mount ON mount.volume_id = file.volume_id AND mount.agent = vol.agent
ORDER BY file.volume_id, dir.depth ASC, path ASC
