/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH stats as (SELECT
  "volume name",
  SUM("volume occupied space") * 100 / SUM("total capacity") AS "Used %",
  SUM("volume occupied space logical") * 100 / SUM("total capacity") AS "Used Logical %"
  FROM sf_reports.stats_current s
  GROUP BY "volume name"
)
SELECT * FROM stats
WHERE "Used %" > 95 OR "Used Logical %" > 95
ORDER BY "Used %" DESC
