/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT
    atime_age AS "Age",
    ROUND(SUM(cost)::NUMERIC, 2) AS "Cost",
    ROUND(Sum(physical_size) / (1024 * 1024 * 1024.0), 2) AS "Size (GiB)"
FROM sf_reports.last_time_generic_current
WHERE atime_months_lower_bound >= 12
GROUP BY atime_age, atime_months_lower_bound
ORDER BY atime_months_lower_bound DESC;

-- Please note: this query is used by more than 1 report. Be careful when modifying it.
