/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

SELECT COALESCE(v.display_name, v.name) AS "volume",
      '/' || path AS "path",
      ROUND((dir.local_aggrs->'total'->>'size')::DECIMAL / (1024 * 1024 * 1024.0), 2) AS "logical size (GiB)",
      ROUND(((dir.local_aggrs->'total'->>'blocks')::BIGINT * 512)::DECIMAL / (1024 * 1024 * 1024.0), 2) AS "physical size (GiB)",
      (dir.local_aggrs->'total'->>'files')::BIGINT AS "file count",
      (dir.local_aggrs->'total'->>'dirs')::BIGINT AS "subdirectory count",
      TO_TIMESTAMP(CAST(dir.local_aggrs->'max'->>'atime' AS BIGINT))::DATE AS "Directory Last Access Time"
FROM sf.dir_current AS dir
INNER JOIN sf_volumes.volume AS v ON dir.volume_id = v.id
LEFT JOIN sf.gid_mapping AS gidm ON gidm.volume_id = v.id AND gidm.gid = dir.gid
WHERE (gidm.name = '{{groupname}}' OR dir.gid::TEXT = '{{groupname}}')
  AND dir.depth <= {{max_depth}}
ORDER BY "logical size (GiB)" DESC
LIMIT {{number_of_rows}}
