/* legal disclaimer in /opt/starfish/data/starfish/sql-copyright-and-license.md */

WITH ajobs AS (
    SELECT
        volume_id,
        target_id,
        archive_target_name,
        EXTRACT(EPOCH FROM (end_time - creation_time)) AS time,
        JSONB_ARRAY_ELEMENTS_TEXT(low_level_jobs::JSONB->'UPLOADING_FILES')::BIGINT AS llj
    FROM sf_archive.archive_job
    WHERE creation_time >= NOW() - INTERVAL '{{number_of_days_to_look_back}} day'
),
jobs AS (
    SELECT
        ajobs.archive_target_name,
        at.type AS target_type,
        (sji.fs_stats->>'fs_bytes_done')::BIGINT AS Bytes,
        CASE WHEN ajobs.time != 0
            THEN (sji.fs_stats->>'fs_bytes_done')::BIGINT / (1000 * 1000.0) / ajobs.time
        ELSE 0.00
        END AS "MB/s"
    FROM ajobs
    INNER JOIN sf_dispatcher.incarnation sji ON ajobs.llj = sji.job_id
    LEFT JOIN sf_archive.archive_target at ON ajobs.target_id = at.id
    LEFT JOIN sf_volumes.volume vol ON vol.id = ajobs.volume_id
)
SELECT
    archive_target_name AS target_name,
    target_type,
    COUNT(*) AS "how many jobs",
    ROUND(SUM(Bytes) / (1000 * 1000 * 1000.0), 2) AS "archived data size GB",
    AVG("MB/s") AS "avg MB/s",
    MAX("MB/s") AS "max MB/s",
    PERCENTILE_CONT(0.5) WITHIN GROUP(ORDER BY "MB/s") AS "median MB/s"
    -- MIN() was skipped because there are too many zeros in customer databases
FROM jobs
GROUP BY target_name,target_type
UNION ALL
SELECT
    'ALL TARGETS', 'ALL',
    COUNT(*) AS "how many jobs",
    ROUND(SUM(Bytes) / (1000 * 1000 * 1000.0), 2) AS "archived data size GB",
    NULL, NULL, NULL
FROM jobs
